/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client;

import com.ibm.hsc.cim.client.HSCCIMClient;
import com.ibm.hsc.cim.client.HSCCltObjCache;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCFrameClient;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.websm.cec.CECInfo;
import com.ibm.websm.diagnostics.IDebug;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class HSCFrameCIMClient
extends HSCCIMClient
implements HSCFrameClient {
    public static final String CEC_CAGE_NUM = "CEC_CAGE_NUM";
    public static final String CEC_MTMS = "CEC_MTMS";
    public static final String CEC_TEMPS = "CEC_TEMPS";
    public static final String IO_CAGE_NUM = "IO_CAGE_NUM";
    public static final String IO_DRAWER_MTMS = "IO_DRAWER_MTMS";
    public static final String IO_DRAWER_MATCHING_CEC_MTMS = "IO_DRAWER_MATCHING_CEC_MTMS";
    public static final String MOF_PORT_NUM = "PortNum";
    public static final String MOF_ORPHANED_IO_NAMES = "OrphanedIONames";
    public static final String MOF_ORPHANED_IO_CAGE = "OrphanedIOCageNum";
    public static final String MOF_IS_FRAME = "isFrame";
    public static final String MOF_FRAME_TYPE = "frameType";
    public static final String MOF_FRAME_NUM = "FrameNumber";

    public static HSCFrameCIMClient createInstance(String string, String string2) throws HSCException {
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_Frame", "root/ibmhscV3_2");
            Enumeration enumeration = HscUtil.getCIMEnumInstances(string, cIMObjectPath, true);
            CIMObjectPath cIMObjectPath2 = null;
            CIMValue cIMValue = null;
            String string3 = null;
            while (enumeration.hasMoreElements()) {
                cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath2, "Name");
                string3 = (String)cIMValue.getValue();
                if (!string3.equals(string2)) continue;
                return new HSCFrameCIMClient(string, string3, cIMObjectPath2);
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return null;
    }

    public HSCFrameCIMClient(String string, String string2, CIMObjectPath cIMObjectPath) {
        super(string, null, string2, cIMObjectPath);
    }

    public Hashtable getFrameAttributes() throws HSCException {
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = null;
        Vector vector = null;
        Vector<Integer> vector2 = new Vector<Integer>();
        try {
            CIMInstance cIMInstance = this.getCIMInstance();
            if (cIMInstance != null) {
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                cIMProperty = cIMInstance.getProperty("Name");
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    hashtable.put("Name", (String)cIMValue.getValue());
                }
                if ((cIMProperty = cIMInstance.getProperty(MOF_IS_FRAME)) != null) {
                    cIMValue = cIMProperty.getValue();
                    if (cIMValue != null) {
                        hashtable.put("frame_PROP", (Boolean)cIMValue.getValue());
                    } else {
                        hashtable.put("frame_PROP", new Boolean(false));
                    }
                } else {
                    hashtable.put("frame_PROP", new Boolean(false));
                }
                cIMProperty = cIMInstance.getProperty(MOF_FRAME_TYPE);
                if (cIMProperty != null) {
                    cIMValue = cIMProperty.getValue();
                    if (cIMValue != null) {
                        UnsignedInt16 unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                        hashtable.put("frameType_PROP", new Integer(unsignedInt16.intValue()));
                    } else {
                        hashtable.put("frameType_PROP", new Integer(4));
                    }
                } else {
                    hashtable.put("frameType_PROP", new Integer(4));
                }
                cIMProperty = cIMInstance.getProperty(MOF_FRAME_NUM);
                if (cIMProperty != null) {
                    cIMValue = cIMProperty.getValue();
                    if (cIMValue != null) {
                        hashtable.put("frameNumber_PROP", ((UnsignedInt16)cIMValue.getValue()).toString());
                    } else {
                        hashtable.put("frameNumber_PROP", "");
                    }
                } else {
                    hashtable.put("frameNumber_PROP", "");
                }
                cIMProperty = cIMInstance.getProperty(MOF_PORT_NUM);
                if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                    vector = (Vector)cIMValue.getValue();
                    for (int i = 0; i < vector.size(); ++i) {
                        UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.elementAt(i);
                        vector2.add(new Integer(unsignedInt32.intValue()));
                    }
                    hashtable.put("portNumbers_PROP", vector2);
                }
                return hashtable;
            }
        }
        catch (Throwable throwable) {
            throw new HSCException(throwable);
        }
        return null;
    }

    public Hashtable getFrameAttributes(String string) throws HSCException {
        return this.getFrameAttributes();
    }

    public Hashtable getCECList() throws HSCException {
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        Hashtable hashtable = null;
        Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
        try {
            HSCCltObjCache hSCCltObjCache = HSCCltObjCache.getInstance();
            Enumeration enumeration = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_FrameCompSys", "IBMHSC_ComputerSystem", "GroupComponent", "PartComponent");
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                    cIMInstance = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath, false);
                    hSCCltObjCache.addObject(cIMInstance);
                    hashtable = CECInfo.getAttributeValues(cIMInstance);
                    hashtable2.put(CECInfo.getKey(cIMObjectPath), hashtable);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        return hashtable2;
    }

    public Hashtable getIODrawerNames() throws HSCException {
        Enumeration enumeration = null;
        Hashtable<String, Number> hashtable = new Hashtable<String, Number>();
        String string = null;
        try {
            enumeration = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_FrameIODrawer", "IBMHSC_IODrawer", "GroupComponent", "PartComponent");
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    CIMValue cIMValue;
                    CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                    CIMInstance cIMInstance = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath, false);
                    CIMProperty cIMProperty = cIMInstance.getProperty("DeviceID");
                    string = null;
                    if (cIMProperty != null && (cIMValue = cIMProperty.getValue()) != null) {
                        string = (String)cIMValue.getValue();
                    }
                    if ((cIMProperty = cIMInstance.getProperty("CageNumber")) == null || (cIMValue = cIMProperty.getValue()) == null || string == null) continue;
                    hashtable.put(string, (Number)cIMValue.getValue());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return hashtable;
    }

    public int refreshFrame(String string) throws HSCException {
        Vector vector = new Vector();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        try {
            vector2.addElement(new CIMProperty("opValue", new CIMValue((Object)new UnsignedInt8(0), new CIMDataType(1))));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RefreshFrame", vector, vector2);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            return 1;
        }
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
        if (unsignedInt8 != null) {
            return unsignedInt8.intValue();
        }
        return 1;
    }

    public void initializeFrame() throws HSCException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "InitializeFrame", vector, vector2);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            throw new HSCException(throwable);
        }
    }

    public int powerOffCSP(Vector vector) throws HSCException {
        Vector<UnsignedInt8> vector2 = null;
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        try {
            if (vector != null) {
                vector2 = new Vector<UnsignedInt8>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(new UnsignedInt8(((Short)enumeration.nextElement()).shortValue()));
                }
                vector3.addElement(new CIMProperty("CecCageNums", new CIMValue(vector2, new CIMDataType(21))));
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PowerOffCSP", vector3, vector4);
            }
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            return 1;
        }
        return 0;
    }

    public int powerOffFSN(Vector vector) throws HSCException {
        Vector<UnsignedInt8> vector2 = null;
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        try {
            if (vector != null) {
                vector2 = new Vector<UnsignedInt8>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(new UnsignedInt8(((Short)enumeration.nextElement()).shortValue()));
                }
                vector3.addElement(new CIMProperty("CecCageNums", new CIMValue(vector2, new CIMDataType(21))));
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PowerOffFSN", vector3, vector4);
            }
        }
        catch (Throwable throwable) {
            if (IDebug.enabled()) {
                throwable.printStackTrace();
            }
            return 1;
        }
        return 0;
    }

    public int resetCSP(Vector vector) throws HSCException {
        Vector<UnsignedInt8> vector2 = null;
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        try {
            if (vector != null) {
                vector2 = new Vector<UnsignedInt8>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(new UnsignedInt8(((Short)enumeration.nextElement()).shortValue()));
                }
                vector3.addElement(new CIMProperty("CecCageNums", new CIMValue(vector2, new CIMDataType(21))));
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "ResetCSP", vector3, vector4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 1;
        }
        return 0;
    }

    public int powerOffIODrawer(Vector vector) throws HSCException {
        Vector<UnsignedInt8> vector2 = null;
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        try {
            if (vector != null) {
                vector2 = new Vector<UnsignedInt8>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    vector2.addElement(new UnsignedInt8(((Short)enumeration.nextElement()).shortValue()));
                }
                vector3.addElement(new CIMProperty("IOCageNums", new CIMValue(vector2, new CIMDataType(21))));
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PowerOffIODrawer", vector3, vector4);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 1;
        }
        return 0;
    }

    public Hashtable getFrameInfo() throws HSCException {
        Vector vector;
        Hashtable<String, Vector> hashtable;
        Vector vector2 = new Vector();
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        try {
            hashtable = null;
            vector = null;
            Object var5_7 = null;
            Object var6_8 = null;
            Object var7_9 = null;
            vector3.addElement(new CIMProperty("IODrawerMtms", new CIMValue(vector, new CIMDataType(29))));
            vector3.addElement(new CIMProperty("IOMatchingCECMtms", new CIMValue(var5_7, new CIMDataType(29))));
            vector3.addElement(new CIMProperty("IOCageNum", new CIMValue(var7_9, new CIMDataType(21))));
            vector3.addElement(new CIMProperty("CECMtms", new CIMValue(hashtable, new CIMDataType(29))));
            vector3.addElement(new CIMProperty("CECCageNum", new CIMValue(var6_8, new CIMDataType(21))));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetFrameInfo", vector2, vector3);
        }
        catch (CIMException cIMException) {
            if (IDebug.enabled) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            throw new HSCException(throwable);
        }
        hashtable = new Hashtable<String, Vector>();
        vector = null;
        vector = (Vector)((CIMProperty)vector3.elementAt(0)).getValue().getValue();
        if (vector != null) {
            hashtable.put(IO_DRAWER_MTMS, vector);
        }
        if ((vector = (Vector)((CIMProperty)vector3.elementAt(1)).getValue().getValue()) != null) {
            hashtable.put(IO_DRAWER_MATCHING_CEC_MTMS, vector);
        }
        if ((vector = (Vector)((CIMProperty)vector3.elementAt(2)).getValue().getValue()) != null) {
            hashtable.put(IO_CAGE_NUM, vector);
        }
        if ((vector = (Vector)((CIMProperty)vector3.elementAt(3)).getValue().getValue()) != null) {
            hashtable.put(CEC_MTMS, vector);
        }
        if ((vector = (Vector)((CIMProperty)vector3.elementAt(4)).getValue().getValue()) != null) {
            hashtable.put(CEC_CAGE_NUM, vector);
        }
        if ((vector = (Vector)((CIMProperty)vector3.elementAt(5)).getValue().getValue()) != null) {
            hashtable.put("FSN_CAGE_NUM", vector);
        }
        if ((vector = (Vector)((CIMProperty)vector3.elementAt(6)).getValue().getValue()) != null) {
            hashtable.put("FSN_MTMS", vector);
        }
        return hashtable;
    }

    public Hashtable getEnvInfo() throws HSCException {
        double d = 0.0;
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Serializable> hashtable2 = new Hashtable<String, Serializable>();
        UnsignedInt8 unsignedInt8 = null;
        Vector vector = new Vector();
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector(3);
        Vector<Hashtable> vector4 = new Vector<Hashtable>();
        Vector vector5 = null;
        try {
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetEnvInfo", vector, vector3);
        }
        catch (CIMException cIMException) {
            if (IDebug.enabled) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
        catch (Throwable throwable) {
            if (IDebug.enabled) {
                throwable.printStackTrace();
            }
            throw new HSCException(throwable);
        }
        vector5 = (Vector)((CIMProperty)vector3.elementAt(0)).getValue().getValue();
        if (vector5 != null) {
            for (int i = 0; i < vector5.size(); ++i) {
                unsignedInt8 = (UnsignedInt8)vector5.get(i);
                vector2.addElement(unsignedInt8.toString());
            }
            hashtable2.put(CEC_TEMPS, vector2);
        }
        int[] nArray = new int[6];
        int[] nArray2 = new int[6];
        for (int i = 1; i < vector3.size(); ++i) {
            int n;
            vector5 = (Vector)((CIMProperty)vector3.elementAt(i)).getValue().getValue();
            if (vector5 == null) continue;
            for (n = 0; n < 3; ++n) {
                nArray2[n] = ((UnsignedInt8)vector5.get(n)).intValue();
            }
            for (n = 3; n < 6; ++n) {
                nArray[n - 3] = ((UnsignedInt8)vector5.get(n)).intValue();
            }
            hashtable = this.powerConversion(nArray2, nArray);
            d += ((Double)hashtable.get("BpaPower")).doubleValue();
            vector4.add(hashtable);
        }
        hashtable2.put("BpaPower", vector4);
        hashtable2.put("BpaTotalPower", new Double(d));
        return hashtable2;
    }

    public void deleteCEC(String string) throws HSCException {
        Object var2_2 = null;
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCCECClient hSCCECClient = null;
        try {
            hSCClientObjectFactory = HSCClientObjectFactory.getInstance(this.mHostName, null);
            hSCCECClient = hSCClientObjectFactory.createCECClient(string, false);
            HscUtil.deleteCIMInstance(this.mHostName, hSCCECClient.getObjectPath());
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    private Hashtable powerConversion(int[] nArray, int[] nArray2) {
        double d = 0.0;
        double d2 = 0.0;
        Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
        Vector<Double> vector = new Vector<Double>();
        Vector<Integer> vector2 = new Vector<Integer>();
        vector2.add(new Integer(nArray[0]));
        vector2.add(new Integer(nArray[1]));
        vector2.add(new Integer(nArray[2]));
        hashtable.put("BpaVoltage", vector2);
        d = (double)(nArray2[0] + nArray2[1]) * 0.866;
        vector.add(new Double(d));
        d2 += (double)nArray[0] * d;
        d = (double)(nArray2[0] + nArray2[1]) * 0.866;
        vector.add(new Double(d));
        d2 += (double)nArray[1] * d;
        d = (double)(nArray2[0] + nArray2[1]) * 0.866;
        vector.add(new Double(d));
        hashtable.put("BpaCurrent", vector);
        hashtable.put("BpaPower", new Double(d2 += (double)nArray[2] * d * 0.5774));
        return hashtable;
    }
}

